/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSet12Byte;
import oracle.sql.CharacterSet1Byte;
import oracle.sql.CharacterSet2ByteFixed;
import oracle.sql.CharacterSetGB18030;
import oracle.sql.CharacterSetJAEUC;
import oracle.sql.CharacterSetLCFixed;
import oracle.sql.CharacterSetSJIS;
import oracle.sql.CharacterSetShift;
import oracle.sql.CharacterSetZHTEUC;
import oracle.sql.converter.CharacterConverterFactory;
import oracle.sql.converter.CharacterConverterFactoryJDBC;
import oracle.sql.converter.JdbcCharacterConverters;

public abstract class CharacterSetWithConverter
extends CharacterSet {
    public static CharacterConverterFactory ccFactory = new CharacterConverterFactoryJDBC();
    JdbcCharacterConverters m_converter;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    CharacterSetWithConverter(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2);
        this.m_converter = jdbcCharacterConverters;
    }

    static CharacterSet getInstance(int n2) {
        JdbcCharacterConverters jdbcCharacterConverters = ccFactory.make(n2);
        if (jdbcCharacterConverters == null) {
            return null;
        }
        CharacterSetWithConverter characterSetWithConverter = null;
        characterSetWithConverter = CharacterSet1Byte.getInstance(n2, jdbcCharacterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetSJIS.getInstance(n2, jdbcCharacterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetShift.getInstance(n2, jdbcCharacterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSet2ByteFixed.getInstance(n2, jdbcCharacterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetGB18030.getInstance(n2, jdbcCharacterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSet12Byte.getInstance(n2, jdbcCharacterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetJAEUC.getInstance(n2, jdbcCharacterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetZHTEUC.getInstance(n2, jdbcCharacterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        return CharacterSetLCFixed.getInstance(n2, jdbcCharacterConverters);
    }

    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.getOracleId() != this.getOracleId();
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        return characterSet.getOracleId() == this.getOracleId();
    }

    @Override
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        return this.m_converter.toUnicodeStringWithReplacement(byArray, n2, n3);
    }

    @Override
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        return this.m_converter.toUnicodeString(byArray, n2, n3);
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        return this.m_converter.toOracleString(string);
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        return this.m_converter.toOracleStringWithReplacement(string);
    }

    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        if (characterSet.getOracleId() == this.getOracleId()) {
            return CharacterSetWithConverter.useOrCopy(byArray, n2, n3);
        }
        return this.convert(characterSet.toString(byArray, n2, n3));
    }
}

