/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;

class T4CRowidAccessor
extends RowidAccessor {
    T4CMAREngine mare;
    final int[] meta = new int[1];
    static final int KGRD_EXTENDED_OBJECT = 6;
    static final int KGRD_EXTENDED_BLOCK = 6;
    static final int KGRD_EXTENDED_FILE = 3;
    static final int KGRD_EXTENDED_SLOT = 3;
    static final int kd4_ubridtype_physical = 1;
    static final int kd4_ubridtype_logical = 2;
    static final int kd4_ubridtype_remote = 3;
    static final int kd4_ubridtype_exttab = 4;
    static final int kd4_ubridtype_future2 = 5;
    static final int kd4_ubridtype_max = 5;
    static final int kd4_ubridlen_typeind = 1;
    static final byte[] kgrd_indbyte_char = new byte[]{65, 42, 45, 40, 41};
    static final byte[] kgrd_basis_64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] kgrd_index_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CRowidAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
        this.defineType = 104;
    }

    T4CRowidAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
        this.defineType = 104;
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        this.rowData = byteArray;
        this.mare = ((T4CConnection)oracleStatement.connection).mare;
        this.rowNull = null;
        this.setCapacity(oracleStatement.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long l2 = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(l2);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                bl = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return bl;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe) {
            this.setNull(this.lastRowProcessed, true);
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            long l2 = this.getOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    AccessorPrototype newPrototype(int n2) {
        assert (n2 >= 0) : "numRows: " + n2;
        AccessorPrototype accessorPrototype = new AccessorPrototype(n2, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement oracleStatement) throws SQLException {
                T4CRowidAccessor t4CRowidAccessor = new T4CRowidAccessor(oracleStatement, T4CRowidAccessor.this.describeMaxLength, T4CRowidAccessor.this.nullable, -1, T4CRowidAccessor.this.precision, T4CRowidAccessor.this.scale, -1, -1, T4CRowidAccessor.this.formOfUse, T4CRowidAccessor.this.definedColumnType, T4CRowidAccessor.this.definedColumnSize, null);
                this.initializeRowData(t4CRowidAccessor);
                return t4CRowidAccessor;
            }
        };
        return accessorPrototype;
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        int n2;
        this.setOffset(this.lastRowProcessed);
        this.rowData.putShort((short)0);
        if (this.describeType == 208) {
            n2 = (int)this.mare.unmarshalUB4();
            if (n2 > 0) {
                ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, n2);
            }
        } else {
            n2 = this.mare.unmarshalUB1();
            if (n2 > 0) {
                this.rowData.putInt((int)this.mare.unmarshalUB4());
                this.rowData.putShort((short)this.mare.unmarshalUB2());
                this.rowData.put((byte)this.mare.unmarshalUB1());
                this.rowData.putInt((int)this.mare.unmarshalUB4());
                this.rowData.putShort((short)this.mare.unmarshalUB2());
            }
        }
        this.processIndicator(n2);
        this.rowData.putShort(this.getOffset(this.lastRowProcessed), (short)n2);
        this.setLength(this.lastRowProcessed, (int)(this.rowData.getPosition() - this.getOffset(this.lastRowProcessed)));
        this.setNull(this.lastRowProcessed, n2 == 0);
        return false;
    }

    byte[] getDecodedBytes(int n2) throws SQLException {
        this.rowData.setPosition(this.getOffset(n2));
        int n3 = this.rowData.getShort();
        if (this.describeType == 208) {
            byte[] byArray = this.getBytesInternal(n2);
            byte[] byArray2 = new byte[4096];
            n3 = T4CRowidAccessor.kgrdub2c(byArray, n3, 2, byArray2, 2);
            byArray2[0] = (byte)(n3 >> 8 & 0xFF);
            byArray2[1] = (byte)(n3 & 0xFF);
            byte[] byArray3 = new byte[n3 + 2];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            return byArray3;
        }
        short s2 = (short)n3;
        long l2 = 0L;
        int n4 = 0;
        short s3 = 0;
        long l3 = 0L;
        int n5 = 0;
        if (s2 > 0) {
            l2 = (long)this.rowData.getInt() & 0xFFFFFFFFL;
            n4 = this.rowData.getShort() & 0xFFFF;
            s3 = (short)(this.rowData.get() & 0xFF);
            l3 = (long)this.rowData.getInt() & 0xFFFFFFFFL;
            n5 = this.rowData.getShort() & 0xFFFF;
        }
        if (l2 == 0L && n4 == 0 && s3 == 0 && l3 == 0L && n5 == 0) {
            return null;
        }
        long[] lArray = new long[]{l2, n4, l3, n5};
        byte[] byArray = T4CRowidAccessor.rowidToString(lArray);
        int n6 = 18;
        if (this.byteLength - 2 < 18) {
            n6 = this.byteLength - 2;
        }
        byte[] byArray4 = new byte[n6 + 2];
        System.arraycopy(byArray, 0, byArray4, 2, n6);
        byArray4[0] = (byte)((n6 & 0xFF00) >> 8);
        byArray4[1] = (byte)(n6 & 0xFF);
        return byArray4;
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        long l2 = this.getOffset(n2);
        if (this.describeType == 208 && this.rowData.get(l2) != 1) {
            byte[] byArray = this.getDecodedBytes(n2);
            if (byArray == null) {
                return null;
            }
            int n3 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            return new String(byArray, 2, n3);
        }
        int n4 = this.getLength(n2);
        byte[] byArray = this.getDecodedBytes(n2);
        if (byArray == null) {
            return null;
        }
        String string = new String(byArray, 2, byArray.length - 2);
        long[] lArray = T4CRowidAccessor.stringToRowid(string.getBytes(), 0, string.length());
        return new String(T4CRowidAccessor.rowidToString(lArray));
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        if (this.isNull(n2)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n2);
            }
            case -8: {
                return this.getROWID(n2);
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        byte[] byArray = this.getDecodedBytes(n2);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length - 2];
        System.arraycopy(byArray, 2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    static final byte[] rowidToString(long[] lArray) {
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        int n2 = 18;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        n3 = T4CRowidAccessor.kgrd42b(byArray, l2, 6, n3);
        n3 = T4CRowidAccessor.kgrd42b(byArray, l3, 3, n3);
        n3 = T4CRowidAccessor.kgrd42b(byArray, l4, 6, n3);
        n3 = T4CRowidAccessor.kgrd42b(byArray, l5, 3, n3);
        return byArray;
    }

    static final long[] rcToRowid(byte[] byArray, int n2, int n3) throws SQLException {
        long l2;
        int n4 = 18;
        if (n3 != n4) {
            throw new SQLException("Rowid size incorrect.");
        }
        long[] lArray = new long[3];
        String string = new String(byArray, n2, n3);
        long l3 = Long.parseLong(string.substring(0, 8), 16);
        long l4 = Long.parseLong(string.substring(9, 13), 16);
        lArray[0] = l2 = Long.parseLong(string.substring(14, 8), 16);
        lArray[1] = l3;
        lArray[2] = l4;
        return lArray;
    }

    static final void kgrdr2rc(int n2, int n3, int n4, int n5, int n6, byte[] byArray, int n7) throws SQLException {
        n7 = T4CRowidAccessor.lmx42h(byArray, n5, 8, n7);
        byArray[n7++] = 46;
        n7 = T4CRowidAccessor.lmx42h(byArray, n6, 4, n7);
        byArray[n7++] = 46;
        n7 = T4CRowidAccessor.lmx42h(byArray, n3, 4, n7);
    }

    static final int lmx42h(byte[] byArray, long l2, int n2, int n3) {
        String string = Long.toHexString(l2).toUpperCase();
        int n4 = n2;
        int n5 = 0;
        do {
            if (n5 < string.length()) {
                byArray[n3 + n2 - 1] = (byte)string.charAt(string.length() - n5 - 1);
                ++n5;
                continue;
            }
            byArray[n3 + n2 - 1] = 48;
        } while (--n2 > 0);
        return n4 + n3;
    }

    static final int kgrdc2ub(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) throws SQLException {
        byte by = T4CRowidAccessor.getRowidType(byArray, n2);
        byte[] byArray3 = byArray2;
        int n5 = n4 - 1;
        int n6 = 0;
        byte[] byArray4 = kgrd_index_64;
        int n7 = 1 + (3 * ((n4 - 1) / 4) + ((n4 - 1) % 4 != 0 ? (n4 - 1) % 4 - 1 : 0));
        if (n5 == 0) {
            SQLException sQLException = DatabaseError.createSqlException(null, 132);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byArray3[n3 + 0] = by;
        n6 = n2 + 1;
        int n8 = 1;
        while (n5 > 0) {
            byte by2;
            if (n5 == 1) {
                SQLException sQLException = DatabaseError.createSqlException(null, 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byte by3 = byArray4[byArray[n6]];
            if (by3 == -1) {
                SQLException sQLException = DatabaseError.createSqlException(null, 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if ((by2 = byArray4[byArray[++n6]]) == -1) {
                SQLException sQLException = DatabaseError.createSqlException(null, 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byArray3[n3 + n8] = (byte)((by3 & 0xFF) << 2 | (by2 & 0x30) >> 4);
            if (n5 == 2) break;
            ++n8;
            by3 = by2;
            if ((by2 = byArray4[byArray[++n6]]) == -1) {
                SQLException sQLException = DatabaseError.createSqlException(null, 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byArray3[n3 + n8] = (byte)((by3 & 0xFF) << 4 | (by2 & 0x3C) >> 2);
            if (n5 == 3) break;
            ++n8;
            by3 = by2;
            if ((by2 = byArray4[byArray[++n6]]) == -1) {
                SQLException sQLException = DatabaseError.createSqlException(null, 132);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byArray3[n3 + n8] = (byte)((by3 & 3) << 6 | by2);
            n5 -= 4;
            ++n6;
            ++n8;
        }
        return n7;
    }

    static final long[] stringToRowid(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = 18;
        if (n3 != n4) {
            throw new SQLException("Rowid size incorrect.");
        }
        long[] lArray = new long[4];
        try {
            lArray[0] = T4CRowidAccessor.kgrdb42(byArray, 6, n2);
            lArray[1] = T4CRowidAccessor.kgrdb42(byArray, 3, n2 += 6);
            lArray[2] = T4CRowidAccessor.kgrdb42(byArray, 6, n2 += 3);
            lArray[3] = T4CRowidAccessor.kgrdb42(byArray, 3, n2 += 6);
            n2 += 3;
        }
        catch (Exception exception) {
            lArray[0] = 0L;
            lArray[1] = 0L;
            lArray[2] = 0L;
            lArray[3] = 0L;
        }
        return lArray;
    }

    static final int kgrd42b(byte[] byArray, long l2, int n2, int n3) {
        int n4 = n2;
        long l3 = l2;
        while (n2 > 0) {
            byArray[n3 + n2 - 1] = kgrd_basis_64[(int)l3 & 0x3F];
            l3 = l3 >>> 6 & 0x3FFFFFFL;
            --n2;
        }
        return n4 + n3;
    }

    static final long kgrdb42(byte[] byArray, int n2, int n3) throws SQLException {
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[n3 + i2];
            if ((by = kgrd_index_64[by]) == -1) {
                throw new SQLException("Char data to rowid conversion failed.");
            }
            l2 <<= 6;
            l2 |= (long)by;
        }
        return l2;
    }

    static final void kgrdr2ec(int n2, int n3, int n4, int n5, int n6, byte[] byArray, int n7) throws SQLException {
        n7 = T4CRowidAccessor.kgrd42b(n2, byArray, n7, 6);
        n7 = T4CRowidAccessor.kgrd42b(n3, byArray, n7, 3);
        n7 = T4CRowidAccessor.kgrd42b(n5, byArray, n7, 6);
        n7 = T4CRowidAccessor.kgrd42b(n6, byArray, n7, 3);
    }

    static final int kgrd42b(int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5 = n4;
        while (n4 > 0) {
            byArray[n3 + --n4] = kgrd_basis_64[n2 & 0x3F];
            n2 >>= 6;
        }
        return n3 + n5;
    }

    static final int kgrdub2c(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws SQLException {
        int n5 = -1;
        byte by = byArray[n3];
        if (by == 1) {
            int n6;
            int[] nArray = new int[byArray.length];
            for (n6 = 0; n6 < byArray.length; ++n6) {
                nArray[n6] = byArray[n6] & 0xFF;
            }
            n6 = n3 + 1;
            int n7 = (((nArray[n6 + 0] << 8) + nArray[n6 + 1] << 8) + nArray[n6 + 2] << 8) + nArray[n6 + 3];
            n6 = n3 + 5;
            int n8 = (nArray[n6 + 0] << 8) + nArray[n6 + 1];
            int n9 = 0;
            n6 = n3 + 7;
            int n10 = (((nArray[n6 + 0] << 8) + nArray[n6 + 1] << 8) + nArray[n6 + 2] << 8) + nArray[n6 + 3];
            n6 = n3 + 11;
            int n11 = (nArray[n6 + 0] << 8) + nArray[n6 + 1];
            if (n7 == 0) {
                T4CRowidAccessor.kgrdr2rc(n7, n8, n9, n10, n11, byArray2, n4);
            } else {
                T4CRowidAccessor.kgrdr2ec(n7, n8, n9, n10, n11, byArray2, n4);
            }
            n5 = 18;
        } else {
            int n12 = 0;
            int n13 = n2 - 1;
            int n14 = 4 * (n2 / 3) + (n2 % 3 == 0 ? n2 % 3 + 1 : 0);
            int n15 = 1 + n14 - 1;
            if (n15 != 0) {
                byArray2[n4 + 0] = kgrd_indbyte_char[by - 1];
                int n16 = n3 + 1;
                n12 = 1;
                byte by2 = 0;
                while (n13 > 0) {
                    byArray2[n4 + n12++] = kgrd_basis_64[(byArray[n16] & 0xFF) >> 2];
                    if (n13 == 1) {
                        byArray2[n4 + n12++] = kgrd_basis_64[(byArray[n16] & 3) << 4];
                        break;
                    }
                    by2 = (byte)(byArray[n16 + 1] & 0xFF);
                    byArray2[n4 + n12++] = kgrd_basis_64[(byArray[n16] & 3) << 4 | (by2 & 0xF0) >> 4];
                    if (n13 == 2) {
                        byArray2[n4 + n12++] = kgrd_basis_64[(by2 & 0xF) << 2];
                        break;
                    }
                    byArray2[n4 + n12++] = kgrd_basis_64[(by2 & 0xF) << 2 | (byArray[n16 += 2] & 0xC0) >> 6];
                    byArray2[n4 + n12] = kgrd_basis_64[byArray[n16] & 0x3F];
                    n13 -= 3;
                    ++n16;
                    ++n12;
                }
            }
            n5 = n12;
        }
        return n5;
    }

    static final boolean isUROWID(byte[] byArray, int n2) {
        return T4CRowidAccessor.getRowidType(byArray, n2) == 2;
    }

    static final byte getRowidType(byte[] byArray, int n2) {
        byte by = 5;
        switch (byArray[n2]) {
            case 65: {
                by = 1;
                break;
            }
            case 42: {
                by = 2;
                break;
            }
            case 45: {
                by = 3;
                break;
            }
            case 40: {
                by = 4;
                break;
            }
            case 41: {
                by = 5;
            }
        }
        return by;
    }
}

