/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

final class NIOHeader {
    int length;
    int packetChecksum;
    int flags;
    int headerChecksum;
    int type;
    final SessionAtts session;
    static final int MAX_RETRIES = 10;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    NIOHeader(SessionAtts sessionAtts) {
        this.session = sessionAtts;
    }

    final void readHeaderBuffer() throws IOException, NetException {
        this.session.headerBuffer.clear();
        int n2 = 0;
        int n3 = 0;
        while (this.session.headerBuffer.hasRemaining()) {
            this.session.socketChannel.read(this.session.headerBuffer);
            n2 = n3 == this.session.headerBuffer.position() ? ++n2 : 0;
            n3 = this.session.headerBuffer.position();
            if (n2 < 10) continue;
            throw new NetException(200);
        }
        this.session.headerBuffer.rewind();
        this.readNSHeader();
    }

    final void readNSHeader() throws IOException {
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12)) {
            this.length = this.session.headerBuffer.getInt() & 0xFFFFFFFF;
        } else {
            this.length = this.session.headerBuffer.getShort() & 0xFFFF;
            this.packetChecksum = this.session.headerBuffer.getShort() & 0xFFFF;
        }
        this.type = this.session.headerBuffer.get() & 0xFF;
        this.flags = this.session.headerBuffer.get() & 0xFF;
        this.headerChecksum = this.session.headerBuffer.getShort() & 0xFFFF;
    }

    final void fillHeaderBuffer() throws IOException {
        this.session.headerBuffer.clear();
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12) || this.type == 15) {
            this.session.headerBuffer.putInt(this.length);
        } else {
            this.session.headerBuffer.putShort((short)this.length);
            this.session.headerBuffer.putShort((short)0);
        }
        this.session.headerBuffer.put((byte)this.type);
        this.session.headerBuffer.put((byte)this.flags);
        this.session.headerBuffer.putShort((short)0);
    }
}

