/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public class OpaqueString
implements Serializable {
    private char[] c;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public static OpaqueString newOpaqueString(String string) {
        OpaqueString opaqueString = new OpaqueString(string);
        return opaqueString;
    }

    private OpaqueString(String string) {
        if (string != null) {
            this.c = new char[string.length()];
            for (int i2 = 0; i2 < string.length(); ++i2) {
                this.c[i2] = string.charAt(i2);
            }
            this.xor();
        } else {
            this.c = null;
        }
    }

    public synchronized String get() {
        if (this.c == null) {
            return null;
        }
        this.xor();
        String string = new String(this.c);
        this.xor();
        return string;
    }

    public void close() {
        Random random = new Random();
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = (char)(this.c[i2] ^ (char)random.nextInt());
        }
    }

    private synchronized void xor() {
        Random random = new Random(super.hashCode() + this.getClass().hashCode());
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = (char)(this.c[i2] ^ random.nextInt());
        }
    }

    public boolean isNull() {
        return this.c == null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        short[] sArray = new short[this.c.length * 2];
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            sArray[i2] = (short)this.c[i2];
        }
        Random random = new Random(super.hashCode() + this.getClass().hashCode());
        int n2 = this.c.length;
        int n3 = 0;
        while (n2 < 2 * this.c.length) {
            sArray[n2] = (short)random.nextInt();
            ++n2;
            ++n3;
        }
        objectOutputStream.writeObject(sArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n2;
        short[] sArray = (short[])objectInputStream.readObject();
        this.c = new char[sArray.length / 2];
        char[] cArray = new char[sArray.length / 2];
        int n3 = sArray.length / 2;
        for (n2 = 0; n2 < n3; ++n2) {
            this.c[n2] = (char)sArray[n2];
        }
        n2 = n3;
        int n4 = 0;
        while (n2 < 2 * n3) {
            cArray[n4] = (char)sArray[n2];
            ++n2;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.c[n2] = (char)(this.c[n2] ^ cArray[n2]);
        }
        this.xor();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    public boolean equals(Object object) {
        OpaqueString opaqueString = (OpaqueString)object;
        boolean bl = this.get().equals(opaqueString);
        return bl;
    }

    public int hashCode() {
        String string = this.get();
        int n2 = string == null ? "".hashCode() : this.get().hashCode();
        return n2;
    }
}

